/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// By Miggy. Dedicated to Nozza.
//
// While creating this shader I noticed both iq and miloyip (and maybe others?) did something similar before. 
// Sorry guys, I promise I did not copy a single line!

void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    vec2 p  = vec2( 0.5, 0.4 );
    
    vec2 uv_ = uv - p;
    uv_ *= vec2( 10., 7. );
    
    float cos_t    = cos( 5. * iGlobalTime );
    float cos_t_pi = cos( 5. * iGlobalTime + 3.1416 );
    
    float pulse_shape  = 1.0 - 4. * cos_t    * ( 1. - cos_t    ) * 0.011;
    float pulse_colour = 1.0 - 4. * cos_t_pi * ( 1. - cos_t_pi ) * 0.03;
    
    float heart_y = uv_.y - sqrt( abs( uv_.x ));
    float heart   = uv_.x * uv_.x * pulse_shape + heart_y * heart_y;
    
    float outer  = 1. - smoothstep( 3., 3.3, heart );
    float middle = 1. - smoothstep( 0., 2.9, heart );
    float inner  = 1. - smoothstep( 0., 2.5, heart );
    
    float bg = 1. - outer;
    
    outer  *= pulse_colour;
    middle *= pulse_colour;
    inner  *= pulse_colour;
    
    vec3 outer_color  = vec3( outer  * 0.60, outer  * 0.06, outer  * 0.20 );
    vec3 middle_color = vec3( middle * 0.08, middle * 0.08, middle * 0.08 );
    vec3 inner_color  = vec3( inner  * 0.14, inner  * 0.11, inner  * 0.11 );
    vec3 bg_color     = vec3( bg     * 0.77, bg     * 0.67, bg     * 0.61 );
    
    vec2 p_center = uv - vec2( 0.5, 0.5 );
    
    float radius = 0.1 + 0.1 * cos( atan( p_center.y, p_center.x ) * 17.0 + iGlobalTime * 1.3 ) * 1.4;
    
    bg_color *= ( 1.0 - smoothstep( radius, radius + 0.8, length( p_center ))) * 2.5;
    bg_color *= ( pow( 1.0 - length( p_center ), 3.2 ) + ( cos_t * 0.5 + 0.5 ) * 0.13 );
    
    vec3 leaf_colour = vec3( 0., 0., 0. );
    
    // Number of leafs. to be incremented by one every 6th of January
    
    const float numLeafs = 1.;
    
    for( float i = 0.; i < numLeafs; i++ )
    {
        vec2 uv_leaf = uv_ * vec2( 6., 6. );
        
        float alpha = 6.28 * i / numLeafs + iGlobalTime / 3.0;
        
        uv_leaf.x += -1.3 * ( 19. * pow( sin( alpha ), 3.0 )) + 0.33;
        uv_leaf.y += -1.3 * ( 13. * cos( alpha ) - 5. * cos( 2. * alpha ) - 2. * cos( 3. * alpha ) - cos( 4. * alpha )) - 7.7;
        
        alpha = iGlobalTime + i * 1.8;
        
        float rot_x = cos( alpha ) * uv_leaf.x - sin( alpha ) * uv_leaf.y;
        float rot_y = sin( alpha ) * uv_leaf.x + cos( alpha ) * uv_leaf.y;
        
        uv_leaf.x = rot_x;
        uv_leaf.y = rot_y;
        
        float leaf_y = uv_leaf.y - exp( uv_leaf.x );
    	float leaf   = uv_leaf.x * uv_leaf.x + leaf_y * leaf_y;
        
        leaf = 1. - smoothstep( 0.3, 0.35, leaf );
        
        float dist_central_line     = abs( exp( uv_leaf.x ) - uv_leaf.y );
        float dist_vertical_lines   = mod( uv_leaf.y, 0.3 );
        float dist_horizontal_lines = mod( uv_leaf.x + 0.1, 0.3 );
        
        leaf = leaf * 0.8 * pow( dist_central_line, 0.3 );
        
        if( sign( exp( uv_leaf.x ) - uv_leaf.y ) > 0. )
        {
            leaf *= pow( dist_vertical_lines, 0.3 );
        }
        else
        {
            leaf *= pow( dist_horizontal_lines, 0.3 );
        }
        
        leaf_colour += vec3( leaf * 0.2, leaf * 1.3, leaf * 0.2 );
    }
    
    gl_FragColor = vec4( outer_color, 1.0 ) + vec4( middle_color, 1.0 ) + vec4( inner_color, 1.0 ) + 
        		   vec4( leaf_colour, 1.0 ) + vec4( bg_color    , 1.0 );
}
